<?php
//
// WARNING: Do not edit by hand, this file was generated by Crank:
// https://github.com/gocardless/crank
//

namespace GoCardlessPro\Integration;

class MandateImportsIntegrationTest extends IntegrationTestBase
{
    public function testResourceModelExists()
    {
        $obj = new \GoCardlessPro\Resources\MandateImport(array());
        $this->assertNotNull($obj);
    }
    
    public function testMandateImportsCreate()
    {
        $fixture = $this->loadJsonFixture('mandate_imports')->create;
        $this->stub_request($fixture);

        $service = $this->client->mandateImports();
        $response = call_user_func_array(array($service, 'create'), (array)$fixture->url_params);

        $body = $fixture->body->mandate_imports;
    
        $this->assertInstanceOf('\GoCardlessPro\Resources\MandateImport', $response);

        $this->assertEquals($body->created_at, $response->created_at);
        $this->assertEquals($body->id, $response->id);
        $this->assertEquals($body->scheme, $response->scheme);
        $this->assertEquals($body->status, $response->status);
    

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    public function testMandateImportsCreateWithIdempotencyConflict()
    {
        $fixture = $this->loadJsonFixture('mandate_imports')->create;

        $idempotencyConflictResponseFixture = $this->loadFixture('idempotent_creation_conflict_invalid_state_error');

        // The POST request responds with a 409 to our original POST, due to an idempotency conflict
        $this->mock->append(new \GuzzleHttp\Psr7\Response(409, [], $idempotencyConflictResponseFixture));

        // The client makes a second request to fetch the resource that was already
        // created using our idempotency key. It responds with the created resource,
        // which looks just like the response for a successful POST request.
        $this->mock->append(new \GuzzleHttp\Psr7\Response(200, [], json_encode($fixture->body)));

        $service = $this->client->mandateImports();
        $response = call_user_func_array(array($service, 'create'), (array)$fixture->url_params);
        $body = $fixture->body->mandate_imports;

        $this->assertInstanceOf('\GoCardlessPro\Resources\MandateImport', $response);

        $this->assertEquals($body->created_at, $response->created_at);
        $this->assertEquals($body->id, $response->id);
        $this->assertEquals($body->scheme, $response->scheme);
        $this->assertEquals($body->status, $response->status);
        

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $conflictRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $conflictRequest->getUri()->getPath());
        $getRequest = $this->history[1]['request'];
        $this->assertEquals($getRequest->getUri()->getPath(), '/mandate_imports/ID123');
    }
    
    public function testMandateImportsGet()
    {
        $fixture = $this->loadJsonFixture('mandate_imports')->get;
        $this->stub_request($fixture);

        $service = $this->client->mandateImports();
        $response = call_user_func_array(array($service, 'get'), (array)$fixture->url_params);

        $body = $fixture->body->mandate_imports;
    
        $this->assertInstanceOf('\GoCardlessPro\Resources\MandateImport', $response);

        $this->assertEquals($body->created_at, $response->created_at);
        $this->assertEquals($body->id, $response->id);
        $this->assertEquals($body->scheme, $response->scheme);
        $this->assertEquals($body->status, $response->status);
    

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    
    public function testMandateImportsSubmit()
    {
        $fixture = $this->loadJsonFixture('mandate_imports')->submit;
        $this->stub_request($fixture);

        $service = $this->client->mandateImports();
        $response = call_user_func_array(array($service, 'submit'), (array)$fixture->url_params);

        $body = $fixture->body->mandate_imports;
    
        $this->assertInstanceOf('\GoCardlessPro\Resources\MandateImport', $response);

        $this->assertEquals($body->created_at, $response->created_at);
        $this->assertEquals($body->id, $response->id);
        $this->assertEquals($body->scheme, $response->scheme);
        $this->assertEquals($body->status, $response->status);
    

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    
    public function testMandateImportsCancel()
    {
        $fixture = $this->loadJsonFixture('mandate_imports')->cancel;
        $this->stub_request($fixture);

        $service = $this->client->mandateImports();
        $response = call_user_func_array(array($service, 'cancel'), (array)$fixture->url_params);

        $body = $fixture->body->mandate_imports;
    
        $this->assertInstanceOf('\GoCardlessPro\Resources\MandateImport', $response);

        $this->assertEquals($body->created_at, $response->created_at);
        $this->assertEquals($body->id, $response->id);
        $this->assertEquals($body->scheme, $response->scheme);
        $this->assertEquals($body->status, $response->status);
    

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    
}
