<?php
//
// WARNING: Do not edit by hand, this file was generated by Crank:
// https://github.com/gocardless/crank
//

namespace GoCardlessPro\Integration;

class BankAuthorisationsIntegrationTest extends IntegrationTestBase
{
    public function testResourceModelExists()
    {
        $obj = new \GoCardlessPro\Resources\BankAuthorisation(array());
        $this->assertNotNull($obj);
    }
    
    public function testBankAuthorisationsGet()
    {
        $fixture = $this->loadJsonFixture('bank_authorisations')->get;
        $this->stub_request($fixture);

        $service = $this->client->bankAuthorisations();
        $response = call_user_func_array(array($service, 'get'), (array)$fixture->url_params);

        $body = $fixture->body->bank_authorisations;
    
        $this->assertInstanceOf('\GoCardlessPro\Resources\BankAuthorisation', $response);

        $this->assertEquals($body->authorisation_type, $response->authorisation_type);
        $this->assertEquals($body->authorised_at, $response->authorised_at);
        $this->assertEquals($body->created_at, $response->created_at);
        $this->assertEquals($body->expires_at, $response->expires_at);
        $this->assertEquals($body->id, $response->id);
        $this->assertEquals($body->last_visited_at, $response->last_visited_at);
        $this->assertEquals($body->links, $response->links);
        $this->assertEquals($body->redirect_uri, $response->redirect_uri);
        $this->assertEquals($body->url, $response->url);
    

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    
    public function testBankAuthorisationsCreate()
    {
        $fixture = $this->loadJsonFixture('bank_authorisations')->create;
        $this->stub_request($fixture);

        $service = $this->client->bankAuthorisations();
        $response = call_user_func_array(array($service, 'create'), (array)$fixture->url_params);

        $body = $fixture->body->bank_authorisations;
    
        $this->assertInstanceOf('\GoCardlessPro\Resources\BankAuthorisation', $response);

        $this->assertEquals($body->authorisation_type, $response->authorisation_type);
        $this->assertEquals($body->authorised_at, $response->authorised_at);
        $this->assertEquals($body->created_at, $response->created_at);
        $this->assertEquals($body->expires_at, $response->expires_at);
        $this->assertEquals($body->id, $response->id);
        $this->assertEquals($body->last_visited_at, $response->last_visited_at);
        $this->assertEquals($body->links, $response->links);
        $this->assertEquals($body->redirect_uri, $response->redirect_uri);
        $this->assertEquals($body->url, $response->url);
    

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    public function testBankAuthorisationsCreateWithIdempotencyConflict()
    {
        $fixture = $this->loadJsonFixture('bank_authorisations')->create;

        $idempotencyConflictResponseFixture = $this->loadFixture('idempotent_creation_conflict_invalid_state_error');

        // The POST request responds with a 409 to our original POST, due to an idempotency conflict
        $this->mock->append(new \GuzzleHttp\Psr7\Response(409, [], $idempotencyConflictResponseFixture));

        // The client makes a second request to fetch the resource that was already
        // created using our idempotency key. It responds with the created resource,
        // which looks just like the response for a successful POST request.
        $this->mock->append(new \GuzzleHttp\Psr7\Response(200, [], json_encode($fixture->body)));

        $service = $this->client->bankAuthorisations();
        $response = call_user_func_array(array($service, 'create'), (array)$fixture->url_params);
        $body = $fixture->body->bank_authorisations;

        $this->assertInstanceOf('\GoCardlessPro\Resources\BankAuthorisation', $response);

        $this->assertEquals($body->authorisation_type, $response->authorisation_type);
        $this->assertEquals($body->authorised_at, $response->authorised_at);
        $this->assertEquals($body->created_at, $response->created_at);
        $this->assertEquals($body->expires_at, $response->expires_at);
        $this->assertEquals($body->id, $response->id);
        $this->assertEquals($body->last_visited_at, $response->last_visited_at);
        $this->assertEquals($body->links, $response->links);
        $this->assertEquals($body->redirect_uri, $response->redirect_uri);
        $this->assertEquals($body->url, $response->url);
        

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $conflictRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $conflictRequest->getUri()->getPath());
        $getRequest = $this->history[1]['request'];
        $this->assertEquals($getRequest->getUri()->getPath(), '/bank_authorisations/ID123');
    }
    
}
