<?php
/**
 * WARNING: Do not edit by hand, this file was generated by Crank:
 *
 * https://github.com/gocardless/crank
 */

namespace GoCardlessPro\Services;

use \GoCardlessPro\Core\Paginator;
use \GoCardlessPro\Core\Util;
use \GoCardlessPro\Core\ListResponse;
use \GoCardlessPro\Resources\Block;
use \GoCardlessPro\Core\Exception\InvalidStateException;


/**
 * Service that provides access to the Block
 * endpoints of the API
 *
 * @method create()
 * @method get()
 * @method list()
 * @method disable()
 * @method enable()
 * @method blockByRef()
 */
class BlocksService extends BaseService
{

    protected $envelope_key   = 'blocks';
    protected $resource_class = '\GoCardlessPro\Resources\Block';


    /**
     * Create a block
     *
     * Example URL: /blocks
     *
     * @param  string[mixed] $params An associative array for any params
     * @return Block
     **/
    public function create($params = array())
    {
        $path = "/blocks";
        if(isset($params['params'])) { 
            $params['body'] = json_encode(array($this->envelope_key => (object)$params['params']));
        
            unset($params['params']);
        }

        
        try {
            $response = $this->api_client->post($path, $params);
        } catch(InvalidStateException $e) {
            if ($e->isIdempotentCreationConflict()) {
                if ($this->api_client->error_on_idempotency_conflict) {
                    throw $e;
                }
                return $this->get($e->getConflictingResourceId());
            }

            throw $e;
        }
        

        return $this->getResourceForResponse($response);
    }

    /**
     * Get a single block
     *
     * Example URL: /blocks/:identity
     *
     * @param  string        $identity Unique identifier, beginning with "BLC".
     * @param  string[mixed] $params   An associative array for any params
     * @return Block
     **/
    public function get($identity, $params = array())
    {
        $path = Util::subUrl(
            '/blocks/:identity',
            array(
                
                'identity' => $identity
            )
        );
        if(isset($params['params'])) { $params['query'] = $params['params'];
            unset($params['params']);
        }

        
        $response = $this->api_client->get($path, $params);
        

        return $this->getResourceForResponse($response);
    }

    /**
     * List multiple blocks
     *
     * Example URL: /blocks
     *
     * @param  string[mixed] $params An associative array for any params
     * @return ListResponse
     **/
    protected function _doList($params = array())
    {
        $path = "/blocks";
        if(isset($params['params'])) { $params['query'] = $params['params'];
            unset($params['params']);
        }

        
        $response = $this->api_client->get($path, $params);
        

        return $this->getResourceForResponse($response);
    }

    /**
     * Disable a block
     *
     * Example URL: /blocks/:identity/actions/disable
     *
     * @param  string        $identity Unique identifier, beginning with "BLC".
     * @param  string[mixed] $params   An associative array for any params
     * @return Block
     **/
    public function disable($identity, $params = array())
    {
        $path = Util::subUrl(
            '/blocks/:identity/actions/disable',
            array(
                
                'identity' => $identity
            )
        );
        if(isset($params['params'])) { 
            $params['body'] = json_encode(array("data" => (object)$params['params']));
        
            unset($params['params']);
        }

        
        try {
            $response = $this->api_client->post($path, $params);
        } catch(InvalidStateException $e) {
            if ($e->isIdempotentCreationConflict()) {
                if ($this->api_client->error_on_idempotency_conflict) {
                    throw $e;
                }
                return $this->get($e->getConflictingResourceId());
            }

            throw $e;
        }
        

        return $this->getResourceForResponse($response);
    }

    /**
     * Enable a block
     *
     * Example URL: /blocks/:identity/actions/enable
     *
     * @param  string        $identity Unique identifier, beginning with "BLC".
     * @param  string[mixed] $params   An associative array for any params
     * @return Block
     **/
    public function enable($identity, $params = array())
    {
        $path = Util::subUrl(
            '/blocks/:identity/actions/enable',
            array(
                
                'identity' => $identity
            )
        );
        if(isset($params['params'])) { 
            $params['body'] = json_encode(array("data" => (object)$params['params']));
        
            unset($params['params']);
        }

        
        try {
            $response = $this->api_client->post($path, $params);
        } catch(InvalidStateException $e) {
            if ($e->isIdempotentCreationConflict()) {
                if ($this->api_client->error_on_idempotency_conflict) {
                    throw $e;
                }
                return $this->get($e->getConflictingResourceId());
            }

            throw $e;
        }
        

        return $this->getResourceForResponse($response);
    }

    /**
     * Create blocks by reference
     *
     * Example URL: /block_by_ref
     *
     * @param  string[mixed] $params An associative array for any params
     * @return ListResponse
     **/
    public function blockByRef($params = array())
    {
        $path = "/block_by_ref";
        if(isset($params['params'])) { 
            $params['body'] = json_encode(array("data" => (object)$params['params']));
        
            unset($params['params']);
        }

        
        try {
            $response = $this->api_client->post($path, $params);
        } catch(InvalidStateException $e) {
            if ($e->isIdempotentCreationConflict()) {
                if ($this->api_client->error_on_idempotency_conflict) {
                    throw $e;
                }
                return $this->get($e->getConflictingResourceId());
            }

            throw $e;
        }
        

        return $this->getResourceForResponse($response);
    }

    /**
     * List multiple blocks
     *
     * Example URL: /blocks
     *
     * @param  string[mixed] $params
     * @return Paginator
     **/
    public function all($params = array())
    {
        return new Paginator($this, $params);
    }

}
